  '' PCA9685 Demo - REFER TO GUI
  OPTION BASE 0
  OPTION AUTORUN ON
  CONST ADDRESS = &H40
  CONST PCA9685ALL = &HFA
  CONST MAGIC = 24414  'magic value for prescaler/frequency calculations
FUNCTION PCA9685LEDS(X AS INTEGER)
  PCA9685LEDS=X*4+6
END FUNCTION
  DIM INTEGER T,X,Y         ''TEMP VARIABLE, TOUCH COORDINATES
  dim INTEGER S(16),D(16)   ''START, DURATION OF PULSES (0-4096)
  DIM INTEGER F             ''FREQUENCY 24-1526 (HARWDARE LIMITED)
  FOR T = 0 TO 15
    S(T)=0
    D(T)=0
  NEXT T
  F = 24
  
  ''STARTUP
  I2C OPEN 400,100    ''PCA9685 can work up to 1MHz, 400 kHz is Micromite limit
  'DUMPREGS()         ''FOR DEBUGGING
  PCA9685INIT(ADDRESS)
  PCA9685SETLEDS(ADDRESS,PCA9685ALL,0,0)
  T=PCA9685SETF(ADDRESS,F)
  PRINT "FREQUENCY:";T
  'DUMPREGS()         ''FOR DEBUGGING
  ''GUI SETUP
  CLS
  DIM L$ AS STRING
  DIM N$ AS STRING
  FOR T = 0 TO 8     ''DRAW SLIDERS, ASSUMES 240X320 LANDSCAPE DISPLAY
    LINE 20+T*35,25,20+T*35,226,,RGB(128,128,128)
    LINE 10+T*35,25,30+T*35,25,,RGB(128,128,128)
    LINE 10+T*35,226,30+T*35,226,,RGB(128,128,128)
    L$="S"+STR$((T-1)\2)
    N$=RIGHT$("    "+STR$(S((T-1)\2)),4)
    IF (T AND 1)=0 THEN L$="D"+STR$((T-1)\2):N$=RIGHT$("    "+STR$(D((T-1)\2)),4)
    IF T=0 THEN L$="F":N$=RIGHT$("    "+STR$(F),4)
    TEXT 20+T*35,227,L$,"CT",1,1,RGB(WHITE),RGB(BLACK)
    DRAWSLIDER(T,0,26)
  next T
    N$="  24"
  DRAWSLIDER(0,26,29)   ''F SLIDER IN DIFFERENT SPOT
  'MAIN LOOP
  DO
    X=TOUCH(X)
    X=(X-2)\35    ''SNAP TO SLIDERS
    Y=TOUCH(Y)
    IF ((X>-1) AND (Y>-1)) THEN
      IF X = 0 THEN
        T=PCA9685SETF(ADDRESS,(Y-26)*8)
        N$=RIGHT$("    "+STR$(T),4)
        DRAWSLIDER(0,F\8+26,T\8+26)
        F=T
      ELSE
        T=(Y-26)*21
        IF T<0 THEN T=0
        IF T>4096 THEN T=4096
        IF (X AND 1)=1 THEN
          N$=RIGHT$("    "+STR$(T),4)
          DRAWSLIDER(X,S((X-1)\2)\21+26,T\21+26)
          S((X-1)\2)=T
          PCA9685SETLEDS(ADDRESS,PCA9685LEDS((X-1)\2),S((X-1)\2),D((X-1)\2))
        else
          N$=RIGHT$("    "+STR$(T),4)
          DRAWSLIDER(X,D((X-1)\2)\21+26,T\21+26)
          D((X-1)\2)=T
          PCA9685SETLEDS(ADDRESS,PCA9685LEDS((X-1)\2),S((X-1)\2),D((X-1)\2))
        endif
      ENDIF
    ENDIF
    IF INKEY$="D" THEN DUMPREGS()
  LOOP
  
END
  
SUB DRAWSLIDER(U AS INTEGER, V AS INTEGER, W AS INTEGER)    'U=X (INDEXED) , V=OLD Y, W= NEW Y
  LINE 10+U*35,V,19+U*35,V,,RGB(0,0,0)
  LINE 21+U*35,V,30+U*35,V,,RGB(0,0,0)
  LINE 10+U*35,W,19+U*35,W,,RGB(255,255,255)
  LINE 21+U*35,W,30+U*35,W,,RGB(255,255,255)
  TEXT 20+U*35,10,N$,"CT",1,1,RGB(WHITE),RGB(BLACK)
END SUB
  
SUB PCA9685SETLEDS(ADD AS INTEGER, REG AS INTEGER, START AS INTEGER, DURATION AS INTEGER)   ''TO LET US USE FUNCTION BUT IGNORE RETURN VALUE
  LOCAL INTEGER X
  X=PCA9685SETLEDSF(ADD,REG,START,DURATION)
end sub
  
SUB PCA9685WRITE(ADD AS INTEGER, REG AS INTEGER, D AS INTEGER)    ''write REG with D at address ADD
  I2C WRITE ADD,0,2,REG,D
END SUB
  
FUNCTION PCA9685READ(ADD AS INTEGER, REG AS INTEGER)      ''read from REG at ADD
  I2C WRITE ADD,1,1,REG
  I2C READ ADD,0,1,PCA9685READ
END FUNCTION
  
SUB PCA9685INIT(ADD AS INTEGER)
  LOCAL INTEGER R,B
  B=PCA9685READ(ADD,0)
  PCA9685WRITE(ADD,0,B AND (255-16))  'clear sleep
  'PCA9685WRITE(ADD,1,&H14)''totem pole driver, inverted
  PCA9685WRITE(ADD,1,&H04)''totem pole driver, not inverted
  PAUSE 1
END SUB
  
SUB DUMPREGS()
  LOCAL INTEGER I
  FOR I = 0 to 255
    PRINT "0x";HEX$(i,2);":0x";HEX$(PCA9685READ(ADDRESS,I) AND &HFF,2);"  ";
    IF I = 69 THEN I = 239
    if (I AND &HF) = &HF THEN PRINT
  NEXT I
END SUB
  
FUNCTION PCA9685SETLEDSF(ADD AS INTEGER, REG AS INTEGER, START AS INTEGER, DURATION AS INTEGER)
  'USE PCA9685ALL OR PCA9685LEDS(N) AS REG, SETS START AND DURATION, TAKES CARE OF SPECIAL CASES
  LOCAL INTEGER FINISH
  IF DURATION < 1 then          'SPECIAL REG SETTINGS FOR 0% DUTY CYCLE
    PCA9685WRITE(ADD,REG,&H00)
    PCA9685WRITE(ADD,REG+1,&H00)
    PCA9685WRITE(ADD,REG+2,&H00)
    PCA9685WRITE(ADD,REG+3,&H10)
    PCA9685SETLEDSF=0
    EXIT FUNCTION
  ENDIF
  IF DURATION > 4095 then          'SPECIAL REG SETTINGS FOR 100% DUTY CYCLE
    PCA9685WRITE(ADD,REG,&H00)
    PCA9685WRITE(ADD,REG+1,&H10)
    PCA9685WRITE(ADD,REG+2,&H00)
    PCA9685WRITE(ADD,REG+3,&H00)
    PCA9685SETLEDSF=4096
    EXIT FUNCTION
  ENDIF
  START=START and &HFFF           'CROP TO 12 BITS
  FINISH = START + DURATION
  FINISH = FINISH AND &HFFF
  PCA9685WRITE(ADD,REG,START AND &HFF)
  PCA9685WRITE(ADD,REG+1,(START\256)AND &HFF)
  PCA9685WRITE(ADD,REG+2,FINISH AND &HFF)
  PCA9685WRITE(ADD,REG+3,(FINISH\256)AND &HFF)
  PCA9685SETLEDSF=DURATION
end function
  
SUB PCA9685SETPS(ADD AS INTEGER, DATA AS INTEGER)
  LOCAL INTEGER R,B
  IF DATA < 3 THEN DATA = 3
  IF DATA > 255 THEN DATA = 255
  B=PCA9685READ(ADD,0)
  PCA9685WRITE(ADD,0,B OR 16)         'set sleep
  PCA9685WRITE(ADD,&HFE,DATA)         'set PS
  B=PCA9685READ(ADD,0)
  PCA9685WRITE(ADD,0,B AND (255-16))  'clear sleep
END SUB
  
FUNCTION PCA9685SETF(ADD AS INTEGER, FREQ AS INTEGER)
  LOCAL INTEGER PS
  IF FREQ < 24 THEN FREQ = 24
  IF FREQ > 1526 THEN FREQ = 1526
  PS = ((MAGIC\FREQ)+2)\4         'CALCULATE PS WITH ROUNDING
  FREQ = ((MAGIC\PS)+2)\4         'CALCUALTE EFFECTIVE FREQUENCY
  PS=PS-1                         'PS REGISTER IS ZERO BASED
  PRINT "PRESCALER:";PS
  PCA9685SETPS(ADD,PS)
  PCA9685SETF=FREQ                'RETURN ACTUAL FREQUENCY SET
END FUNCTION

